﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class HiderController : MonoBehaviour
{
    public GameObject CurrentHideLocation { get; private set; }
    private bool IsUnhiding = false;    //Are we in the process of unhiding?

    private void OnTriggerStay2D(Collider2D collision)
    {
        if (GameController.Instance.CurrentGamePhase.GetType() == typeof(HidingPhase))
        {
            if ((Input.GetKeyUp(KeyCode.Space) || Input.GetKeyUp("joystick button 0")))
            {
                if (!IsUnhiding)
                {
                    if (GameController.Instance.HidingObject == null)
                    {
                        if (collision is BoxCollider2D)
                        {
                            if (collision.tag == Constants.HidableTag)
                            {
                                //We pressed the hide key, aren't unhiding or already hiding and are colliding with a hidable, so let's hide here
                                GameController.Instance.SetHideLocation(collision.gameObject);
                            }

                            else
                            {
                                Debug.Log("We can't hide here. Did you remember to set the game object tag?");
                            }
                        }
                    }
                }

                else
                {
                    IsUnhiding = false;
                }
            }

            else
            {
                if (GameController.Instance.HidingObject == null)
                {
                    if (collision is BoxCollider2D)
                    {
                        if (collision.tag == Constants.HidableTag)
                        {
                            //We're colliding, so let's set the legend
                            GameController.Instance.SetCharacterLegend(InputManager.Instance.InputState, Constants.CharacterLegendType.Hide, Constants.PlayerRole.Hider);
                        }
                    }
                }
            }
        }
    }

    private void OnTriggerExit2D(Collider2D collision)
    {
        //We're no longer colliding, so reset the legend
        GameController.Instance.SetCharacterLegend(InputManager.Instance.InputState, Constants.CharacterLegendType.None, Constants.PlayerRole.Hider);
    }

    void Update()
    {
        if (GameController.Instance.CurrentGamePhase.GetType() == typeof(HidingPhase))
        {
            if (GameController.Instance.HidingObject != null)
            {
                if (Input.GetKeyDown(KeyCode.Backspace) || Input.GetKeyDown("joystick button 1"))
                {
                    //We're in a spot but want to unhide, so let's do that
                    GameController.Instance.UnsetHideLocation();
                    IsUnhiding = true;
                }
            }
        }
    }
}
